<?php
/**
 * Deprecation-safe Twig_Autoloader for legacy Twig 1.x on PHP 8+.
 * - Removes trigger_error() deprecation spam.
 * - Keeps SPL autoload behavior identical to classic implementation.
 */
if (!class_exists('Twig_Autoloader', false)) {
    class Twig_Autoloader
    {
        public static function register($prepend = false)
        {
            spl_autoload_register(array(__CLASS__, 'autoload'), true, (bool)$prepend);
        }

        public static function autoload($class)
        {
            if (0 !== strpos($class, 'Twig_')) {
                return;
            }
            // IMPORTANT: Go up one directory from Twig/Autoloader.php to the base dir,
            // then append 'Twig/...'. This matches the original Twig layout.
            $base = dirname(__FILE__) . '/../';
            $file = $base . str_replace('_', '/', $class) . '.php';
            if (is_file($file)) {
                require $file;
            }
        }
    }
}
