<?php 
include("config.php"); 

// Function to generate Employee ID
function generateEmployeeID() {
    return "EMP" . rand(1000, 9999);
}

$msg = "";

if (isset($_POST['submitbtn'])) {
    extract($_POST);

    $employee_id = generateEmployeeID();
$dob = date("d-m-Y", strtotime($_POST['dob']));
$joining = date("d-m-Y", strtotime($_POST['joining']));


    // File upload
    $image_name = $_FILES['photo']['name'];
    $target_dir = "img/";
    $target_file = $target_dir . basename($image_name);


    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0777, true);
    }

    if (move_uploaded_file($_FILES['photo']['tmp_name'], $target_file)) {
        $q1 = "INSERT INTO register
        (employee_id, fname, lname, email, number, gender, nationality, dob, address, qualification, joining, photo, password) 
        VALUES 
        ('$employee_id', '$fname', '$lname', '$email', '$number', '$gender', '$nationality', '$dob', '$address', '$qua', '$joining', '$image_name', '$password')";

        $e1 = mysqli_query($conn, $q1);
        if ($e1) {
            $msg = "Successfully Registered! Your Employee ID is: <strong>$employee_id</strong>";
        } else {
            $msg = "Registration Failed!";
        }
    } else {
        $msg = "Image upload failed!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Employee Registration</title>
    <link rel="stylesheet" href="bootstrap.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css">
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; color: #333; }
        .container { max-width: 960px; margin: auto; padding: 0 20px; }
        .profile-section { background: #fff; padding: 20px; margin: 20px auto; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .password-wrapper {
        position: relative;
        width: 100%;
        }

.password-wrapper input {
    width: 100%;
    padding-right: 35px; /* make space for the eye icon */
    box-sizing: border-box;
    border: 1px solid #ced4da;
    padding: 8px;
    border-radius: 4px;
}

.password-wrapper img {
    position: absolute;
    top: 50%;
    right: 10px;
    width: 20px;
    height: 20px;
    transform: translateY(-50%);
    cursor: pointer;
    opacity: 0.7;
    transition: opacity 0.2s ease-in-out;
}

.password-wrapper img:hover {
    opacity: 1;
}

    </style>
</head>
<body>
    <div class="profile-section">
        <h3 class="text-center text-primary mt-3 mb-4">Employee Registration</h3>
        <div class="container">
            <?php if ($msg != "") { ?>
                <div class="alert alert-info alert-dismissible fade show" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <?php echo $msg; ?>
                </div>
            <?php } ?>

            <form action="" method="post" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-sm-6 form-group">
                        <label>First Name:</label>
                        <input type="text" name="fname" class="form-control" required>
                    </div>
                    <div class="col-sm-6 form-group">
                        <label>Last Name:</label>
                        <input type="text" name="lname" class="form-control" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6 form-group">
                        <label>Email:</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="col-sm-6 form-group">
                        <label>Phone Number:</label>
                        <input type="number" name="number" class="form-control" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6 form-group">
                        <label>Gender:</label><br>
                        <input type="radio" name="gender" value="Male" required> Male
                        <input type="radio" name="gender" value="Female" required> Female
                    </div>
                    <div class="col-sm-6 form-group">
                        <label>Nationality:</label>
                        <select name="nationality" class="form-control" required>
                            <option disabled selected>--Select--</option>
                            <option value="Indian">Indian</option>
                            <option value="Foreign">Foreign</option>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6 form-group">
                        <label>DOB:</label>
                        <input type="date" name="dob" class="form-control" required>
                    </div>
                    <div class="col-sm-6 form-group">
                        <label>Address:</label>
                        <textarea name="address" class="form-control" required></textarea>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6 form-group">
                        <label>Qualification:</label>
                        <select name="qua" class="form-control" required>
                            <option disabled selected>--Select--</option>
                            <option value="12th">12th</option>
                            <option value="Graduate">Graduate</option>
                            <option value="Master">Master</option>
                            <option value="P.HD">P.HD</option>
                        </select>
                    </div>
                    <div class="col-sm-6 form-group">
                        <label>Joining Date:</label>
                        <input type="date" name="joining" class="form-control">
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6 form-group">
                        <label>Photo:</label>
                        <input type="file" name="photo" class="form-control" required>
                    </div>
                    <div class="col-sm-6 form-group">                        
                        <label>Password:</label><br>
                        <div class="password-wrapper">
                            <input type="password" name="password" id="password" placeholder="Enter password..." required>
                            <img id="togglePassword" src="admin/images/invisible.png" alt="Show/Hide">
                        </div>
                    </div>
                        <input type="submit" name="submitbtn" class="btn btn-primary" value="Register">
                </div>
            </form>

            <br>
            <a href="index.php">Already registered? Login here</a>
            <br><br>
        </div>
    </div>
    <script>
    const togglePassword = document.getElementById("togglePassword");
    const password = document.getElementById("password");

    togglePassword.addEventListener("click", function () {
        if (password.type === "password") {
            password.type = "text";         // show password
            this.src = "admin/images/view.png";       // change to hide icon
        } else {
            password.type = "password";     // hide password
            this.src = "admin/images/invisible.png";           // change back to show icon
        }
    });
</script>
</body>
</html>
