<?php
$role_id = $_SESSION['role_id'];
?>
<?php
include("../config.php");
include 'common/header.php';

$session_username = $_SESSION['username'] ?? '';
$message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $current_password = trim($_POST['current_password']);
    $new_password = trim($_POST['new_password']);

    if (empty($current_password)) {
        $message = "⚠ Please enter your current password.";
    } else {
        $stmt = $conn->prepare("SELECT password FROM user WHERE username = ?");
        $stmt->bind_param("s", $session_username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $row = $result->fetch_assoc()) {
            $stored_password = $row['password'];

            if ($stored_password !== $current_password) {
                $message = "❌ Incorrect current password.";
            } else {
                if (!empty($new_password)) {
                    $update_stmt = $conn->prepare("UPDATE user SET password = ? WHERE username = ?");
                    $update_stmt->bind_param("ss", $new_password, $session_username);
                    if ($update_stmt->execute()) {
                        $message = "✅ Password updated successfully.";
                    } else {
                        $message = "⚠ Failed to update password.";
                    }
                    $update_stmt->close();
                } else {
                    $message = "⚠ New password cannot be empty.";
                }
            }
        } else {
            $message = "❌ No admin found with username: $session_username";
        }
        $stmt->close();
    }
}
?>
<div class="w-full max-w-lg mx-auto bg-white p-8 rounded-lg shadow-md">
    <h1 class="text-2xl font-bold mb-6">Admin Settings</h1>

    <?php if (!empty($message)) : ?>
        <div class="p-3 mb-6 text-sm rounded-lg bg-blue-100 text-blue-800">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="">
        <div class="space-y-6">
            <div class="border-t pt-6">
                <p class="text-gray-600 mb-4">Enter current password to change it. New password is required.</p>
                <div>
                    <label for="current_password" class="block mb-2 text-sm font-medium text-gray-700">Current Password</label>
                    <input type="password" name="current_password" id="current_password" class="input-field" required>
                </div>
                <div class="mt-4">
                    <label for="new_password" class="block mb-2 text-sm font-medium text-gray-700">New Password</label>
                    <input type="password" name="new_password" id="new_password" class="input-field" required>
                </div>
            </div>
        </div>
        <div class="mt-8">
            <button type="submit" class="w-full bg-blue-600 text-white font-bold py-3 px-4 rounded-lg hover:bg-blue-700 transition">Save Settings</button>
        </div>
    </form>
</div>

<style>
.input-field {
    width: 100%;
    padding: 10px;
    border-radius: 8px;
    border: 1px solid #d1d5db;
}
</style>

<?php include 'common/bottom.php'; ?>
