<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ✅ Handle Delete if ?delete=ID is present in URL
if (isset($_GET['delete'])) {
    include '../config.php';
    $delete_id = mysqli_real_escape_string($conn, $_GET['delete']);

    // Delete employee photo if exists
    $photoResult = mysqli_query($conn, "SELECT photo FROM register WHERE employee_id = '$delete_id'");
    if ($photoRow = mysqli_fetch_assoc($photoResult)) {
        $photoPath = '../img/' . $photoRow['photo'];
        if (file_exists($photoPath)) {
            unlink($photoPath);
        }
    }

    // Optional: Also delete attendance records
    mysqli_query($conn, "DELETE FROM attendance WHERE employee_id = '$delete_id'");

    // Delete from register
    mysqli_query($conn, "DELETE FROM register WHERE employee_id = '$delete_id'");

    // Redirect to avoid repeat deletion on refresh
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

include 'common/header.php';   // ✅ Because header.php is inside admin/common/
include '../config.php';    

// Fetch employee records
$sql = "SELECT employee_id, photo, CONCAT(fname, ' ', lname) AS emp_name, qualification, nationality, joining FROM register";
$result = mysqli_query($conn, $sql);
if (!$result) {
    die("Query Failed: " . mysqli_error($conn)); // ✅ correct one
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registered Employees</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="style.css"> <!-- Keep your existing sidebar/dashboard styling -->
    <style>
        body {
            background-color: #f1f3f6;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .content {
            margin-left: 0px;
            padding: 40px 20px;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            background: #f8f9fa;
        }

        .card {
            width: 100%;
            max-width: 1200px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            background: #fff;
            padding: 25px;
        }

        h2 {
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 25px;
            text-align: center;
            color: #333;
        }

        .table th {
            background-color: #343a40;
            color: #fff;
            text-transform: uppercase;
            font-size: 13px;
            letter-spacing: 0.5px;
            text-align: center;
        }

        .table td, .table th {
            vertical-align: middle;
            font-size: 14px;
            text-align: center;
        }

        .table img {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 50%;
            border: 1px solid #ddd;
        }

        .btn-sm {
            padding: 4px 10px;
            font-size: 13px;
            margin: 2px;
        }

        .btn-warning {
            background-color: #ffc107;
            border: none;
        }

        .btn-warning:hover {
            background-color: #e0a800;
        }

        .btn-danger {
            background-color: #dc3545;
            border: none;
        }

        .btn-danger:hover {
            background-color: #c82333;
        }

        .text-center {
            font-weight: 500;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="content">
        <div class="card">
            <h2>Registered Employees</h2>
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Emp ID</th>
                            <th>Emp Photo</th>
                            <th>Emp Name</th>
                            <th>Qualification</th>
                            <th>Nationality</th>
                            <th>Joining Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result) > 0): ?>
                            <?php while($row = mysqli_fetch_assoc($result)): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['employee_id']); ?></td>
                                    <td>
                                        <img src="../img/<?php echo !empty($row['photo']) ? $row['photo'] : 'default.png'; ?>" alt="Photo">
                                    </td>
                                    <td><?php echo ucwords(strtolower(htmlspecialchars($row['emp_name']))); ?></td>
                                    <td><?php echo htmlspecialchars($row['qualification']); ?></td>
                                    <td><?php echo htmlspecialchars($row['nationality']); ?></td>
                                    <td><?php echo htmlspecialchars($row['joining']); ?></td>
                                    <td>
<a href="edit.php?id=<?php echo $row['employee_id']; ?>" class="btn btn-warning btn-sm">Edit</a>
<a href="?delete=<?php echo $row['employee_id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this employee?');">Delete</a>

                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">No employees registered.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
