<?php

session_start();
include '../config.php';

// Redirect if already logged in
if (isset($_SESSION['username']) && isset($_SESSION['role_id'])) {
    if ($_SESSION['role_id'] == 1) {
        header("Location: dashboard.php"); // Super Admin
        exit();
    } elseif ($_SESSION['role_id'] == 2) {
        header("Location: report.php"); // Admin
        exit();
    }
}

$message = "";

// Only check login on form submit
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['adsub'])) {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = mysqli_real_escape_string($conn, $_POST['password']);

    if (!empty($username) && !empty($password)) {
        // Validate user credentials
        $query = "SELECT * FROM user WHERE username = '$username' AND password = '$password'";
        $result = mysqli_query($conn, $query);

        if ($result && mysqli_num_rows($result) == 1) {
            $row = mysqli_fetch_assoc($result);

            // Store all needed session variables
            $_SESSION['user_id'] = $row['id']; 
            $_SESSION['username'] = $row['username'];
            $_SESSION['role_id'] = $row['role_id'];

            // Redirect based on role
            if ($row['role_id'] == 1) {
                $_SESSION['role'] = 'super_admin';
                header("Location: dashboard.php");
                exit();
            } elseif ($row['role_id'] == 2) {
                $_SESSION['role'] = 'admin';
                header("Location: report.php");
                exit();
            }
        } else {
            $message = "Invalid login credentials!";
        }
    } else {
        $message = "Please fill in all fields.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { font-family: 'Inter', sans-serif; }
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');
        .mt-4:hover{
            background-color:rgba(11, 49, 119, 1);
        }
    </style>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="w-full max-w-sm p-8 bg-white rounded-lg shadow-lg">
        <h1 class="text-3xl font-bold text-center text-blue-900 mb-2">Admin Panel</h1>
        <p class="text-center text-gray-500 mb-6">Welcome back</p>

        <?php if (!empty($message)) { ?>
            <p class="text-red-500 text-sm mb-4"><?= $message ?></p>
        <?php } ?>

        <form method="POST" action="" class="space-y-6">
            <div>
                <label for="username" class="block mb-2 text-sm font-medium text-gray-700">Username</label>
                <input type="text" name="username" placeholder="Enter Username" id="username" 
                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg 
                    focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" required>
            </div>

<div>
    <label for="password" class="block mb-2 text-sm font-medium text-gray-700">Password</label>
    <div class="relative">
        <input type="password" name="password" placeholder="******" id="password" 
            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg 
            focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 pr-10" required>

        <!-- Eye Icon -->
        <button type="button" id="togglePassword" 
            class="absolute inset-y-0 right-0 flex items-center pr-3">
            <img id="eyeIcon" src="images/invisible.png" alt="Show" width="22" height="22" />
        </button>
    </div>
</div>
<script>
    const togglePassword = document.getElementById("togglePassword");
    const passwordInput = document.getElementById("password");
    const eyeIcon = document.getElementById("eyeIcon");

    togglePassword.addEventListener("click", function () {
        const type = passwordInput.getAttribute("type") === "password" ? "text" : "password";
        passwordInput.setAttribute("type", type);

        // Change icon
        if (type === "password") {
            eyeIcon.src = "images/invisible.png"; // open eye
        } else {
            eyeIcon.src = "images/view.png"; // closed eye
        }
    });
</script>


            <button type="submit" 
                class="w-full text-white bg-blue-800 hover:bg-blue-900 focus:ring-4 focus:outline-none 
                focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-3 text-center" name="adsub">Login</button>
        </form>
        
        <a href="add_admin.php" 
        class="block w-full mt-4 text-center text-white bg-blue-600  
          focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg 
          text-sm px-5 py-3">
    Don't have an account? Register
</a>

    </div>
</body>
</html>
