<?php

// Start session if not started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Set $role_id only if available
$role_id = $_SESSION['role_id'] ?? null;

// Detect active page
$activePage = basename($_SERVER['PHP_SELF']);
?>
<!-- Sidebar -->
<aside id="admin-sidebar" class="bg-blue-900 text-white w-64 min-h-screen p-4 flex-col fixed lg:relative lg:translate-x-0 transform -translate-x-full transition-transform duration-300 z-40">
    <div class="flex items-center justify-between mb-8">
        <a href="index.php" class="text-xl font-bold">Employee Management</a>
        <button id="admin-close-btn" class="lg:hidden text-xl"><i class="fas fa-times"></i></button>
    </div>
    <nav class="flex flex-col space-y-2">
        <!-- Dashboard -->
        <a href="dashboard.php" class="flex items-center py-2 px-3 rounded 
            <?php echo $activePage == 'dashboard.php' ? 'bg-blue-800 text-white font-semibold border-l-4 border-white' : 'text-white hover:bg-blue-800 transition-colors'; ?>">
            <i class="fas fa-tachometer-alt w-6 mr-3"></i> Dashboard
        </a>

        <!-- New Register (only for role 1) -->
        <?php if ($role_id == 1): ?>
            <a href="register.php" class="flex items-center py-2 px-3 rounded 
                <?php echo $activePage == 'register.php' ? 'bg-blue-800 text-white font-semibold border-l-4 border-white' : 'text-white hover:bg-blue-800 transition-colors'; ?>">
                <i class="fas fa-users w-6 mr-3"></i> New Register
            </a>
        <?php endif; ?>

        <!-- Attendance (only for role 1) -->
        <?php if ($role_id == 1): ?>
            <a href="attendence.php" class="flex items-center py-2 px-3 rounded 
                <?php echo $activePage == 'attendence.php' ? 'bg-blue-800 text-white font-semibold border-l-4 border-white' : 'text-white hover:bg-blue-800 transition-colors'; ?>">
                <i class="fas fa-receipt w-6 mr-3"></i> Attendance
            </a>
        <?php endif; ?>

        <!-- Report (only for role 2) -->
        <?php if ($role_id == 2): ?>
            <a href="report.php" class="flex items-center py-2 px-3 rounded 
                <?php echo $activePage == 'report.php' ? 'bg-blue-800 text-white font-semibold border-l-4 border-white' : 'text-white hover:bg-blue-800 transition-colors'; ?>">
                <i class="fas fa-receipt w-6 mr-3"></i> Report
            </a>
        <?php endif; ?>

        <!-- Settings (for all) -->
        <a href="setting.php" class="flex items-center py-2 px-3 rounded 
            <?php echo $activePage == 'setting.php' ? 'bg-blue-800 text-white font-semibold border-l-4 border-white' : 'text-white hover:bg-blue-800 transition-colors'; ?>">
            <i class="fas fa-cog w-6 mr-3"></i> Settings
        </a>
    </nav>
</aside>
<div id="admin-sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden lg:hidden"></div>
