<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include '../config.php';
include 'common/header.php';

$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

$condition = "";

// If user selected a date range
if (!empty($from_date) && !empty($to_date)) {
    $from_date_sql = date("Y-m-d", strtotime($from_date));
    $to_date_sql = date("Y-m-d", strtotime($to_date));
    $condition = "WHERE DATE(attendance.login_time) BETWEEN '$from_date_sql' AND '$to_date_sql'";
} else {
    // Default: show only last 7 days
    $condition = "WHERE attendance.login_time >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
}

$query = "
    SELECT 
        attendance.id, 
        attendance.employee_id, 
        CONCAT(register.fname, ' ', register.lname) AS full_name, 
        attendance.login_time, 
        attendance.logout_time, 
        attendance.file_path
    FROM attendance 
    INNER JOIN register ON attendance.employee_id = register.employee_id 
    $condition
    ORDER BY attendance.id ASC
";

$result = mysqli_query($conn, $query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Attendance Records</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <h2 class="mb-4 text-center">Employee Attendance Records</h2>

        <!-- 🔍 Date Filter Form -->
        <form method="GET" class="mb-6 w-full">
  <div class="flex justify-between items-center flex-wrap gap-4">

    <!-- Filter Section (Left) -->
    <div class="flex items-center flex-wrap gap-3">
      <label for="from_date" class="font-medium">From:</label>
      <input type="date" id="from_date" name="from_date" class="border border-gray-300 rounded px-3 py-2" value="<?php echo $from_date; ?>" required>

      <label for="to_date" class="font-medium">To:</label>
      <input type="date" id="to_date" name="to_date" class="border border-gray-300 rounded px-3 py-2" value="<?php echo $to_date; ?>" required>

      <button type="submit" class="bg-blue-600 text-white font-semibold px-4 py-2 rounded hover:bg-blue-700 transition">
        Filter
      </button>
    </div>

    <!-- Download Button (Right) -->
    <a href="export_att.php" class="bg-gray-700 text-white font-semibold px-4 py-2 rounded hover:bg-gray-800 transition flex items-center">
      <i class="fas fa-file-alt mr-2"></i>Download Excel File
    </a>

  </div>
</form>


        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="thead-dark">
                    <tr>
                        <th>ID</th>
                        <th>Employee ID</th>
                        <th>Name</th>
                        <th>Login Time</th>
                        <th>Logout Time</th>
                        <th>File</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (mysqli_num_rows($result) > 0): ?>
                        <?php while ($row = mysqli_fetch_assoc($result)): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo htmlspecialchars($row['employee_id']); ?></td>
                                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                <td><?php echo $row['login_time'] ? date("d-m-Y H:i:s", strtotime($row['login_time'])) : '---'; ?></td>
                                <td>
                                    <?php 
                                        if (!empty($row['logout_time']) && $row['logout_time'] != '0000-00-00 00:00:00') {
                                             echo date("d-m-Y H:i:s", strtotime($row['logout_time']));
                                        } else {
                                                echo '---';
                                        }
                                     ?>
                                </td>

                                <td>
                                    <?php 
                                    if (!empty($row['file_path'])) {
                                        $filePath = $row['file_path'];
                                        $fullPath = realpath(__DIR__ . '/../' . $filePath);
                                        $webPath = '../' . $filePath;

                                        if ($fullPath && file_exists($fullPath)) {
                                            echo "<a href='$webPath' target='_blank'>Download File</a>";
                                        } else {
                                            echo "<span style='color:red;'>File Missing</span>";
                                        }
                                    } else {
                                        echo "---";
                                    }
                                    ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">No attendance records found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
