<?php
include("../config.php"); // Database connection

$msg = "";

if (isset($_POST['register'])) {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    $role_id = 2; // Fixed role_id for employee

    if ($username == "" || $password == "") {
        $msg = "All fields are required!";
    } else {
        // Insert into user table
        $sql = "INSERT INTO user (username, password, role_id) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssi", $username, $password, $role_id);

        if ($stmt->execute()) {
            $msg = "User registered successfully!";
        } else {
            $msg = "Error: " . $conn->error;
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Register User</title>
<style>
    body {
        font-family: Arial, sans-serif;
        background-color: #f4f6f8;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        margin: 0;
    }

    .container {
        background: white;
        padding: 20px 30px;
        border-radius: 10px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        width: 300px;
        text-align: center;
    }

    h2 {
        margin-bottom: 20px;
        color: #333;
    }

    .message {
        margin-bottom: 15px;
        padding: 10px;
        border-radius: 5px;
        font-size: 14px;
    }
    .success {
        background-color: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }
    .error {
        background-color: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }

    label {
        display: block;
        text-align: left;
        margin: 10px 0 5px;
        font-weight: bold;
        color: #555;
    }

    input[type="text"],
    input[type="password"] {
        width: 100%;
        padding: 8px 4px 8px 10px; /* padding-right for eye button */
        margin-bottom: 15px;
        border: 1px solid #ccc;
        border-radius: 5px;
        outline: none;
        transition: border 0.3s;
    }

    input[type="text"]:focus,
    input[type="password"]:focus {
        border-color: rgba(45, 105, 218, 1);
    }

    button {
        width: 100%;
        background-color: rgba(45, 105, 218, 1);
        color: white;
        padding: 10px;
        border: none;
        border-radius: 5px;
        font-size: 16px;
        cursor: pointer;
        transition: background 0.3s;
    }

    button:hover {
        background-color: rgba(11, 49, 119, 1);
    }

    a {
        display: block;
        margin-top: 15px;
        color: rgba(45, 105, 218, 1);
        text-decoration: none;
    }

    a:hover {
        text-decoration: underline;
    }

    /* For password field with eye icon */
    .relative {
        position: relative;
    }
    .relative img {
        position: absolute;
        right: 0px;
        top: 50%;
        transform: translateY(-50%);
        width: 22px;
        height: 22px;
        cursor: pointer;
        padding-bottom:10px;
    }
</style>
</head>
<body>

<div class="container">
    <h2>Register User</h2>

    <!-- Display message if set -->
    <?php if (!empty($msg)) { ?>
        <div class="message <?php echo (strpos($msg, 'successfully') !== false) ? 'success' : 'error'; ?>">
            <?php echo htmlspecialchars($msg); ?>
        </div>
    <?php } ?>

    <form method="POST" action="">
        <label>Username</label>
        <input type="text" name="username" placeholder="Enter username" required>
        
        <label>Password</label>
        <div class="relative">
            <input type="password" name="password" placeholder="Enter password" id="password" required>
            <img id="eyeIcon" src="images/invisible.png" alt="Show">
        </div>
        
        <button type="submit" name="register">Register</button>
    </form>

    <a href="index.php">Already registered? Login here</a>
</div>

<script>
    const passwordInput = document.getElementById("password");
    const eyeIcon = document.getElementById("eyeIcon");

    eyeIcon.addEventListener("click", function () {
        const type = passwordInput.getAttribute("type") === "password" ? "text" : "password";
        passwordInput.setAttribute("type", type);

        // Toggle icon
        if (type === "password") {
            eyeIcon.src = "images/invisible.png"; // closed eye
        } else {
            eyeIcon.src = "images/view.png"; // open eye
        }
    });
</script>

</body>
</html>
