<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
include("includes/db.php");
include("includes/header.php");
include("functions/functions.php");
include("includes/main.php");
cart();
?>

<!-- Cover -->
<main>

  <!-- Banner Carousel Section - TOP POSITION like IT Depot -->
  <section class="banner-carousel fade-in">
    <div class="carousel-container">
      <div class="carousel-slides">
        <div class="carousel-slide active">
          <a href="shop.php?cat=pc">
            <img src="images/banner.webp" alt="Premium PC Components">
          </a>
        </div>
        <div class="carousel-slide">
          <a href="shop.php?cat=laptop">
            <img src="images/banner2.jpg" alt="Gaming Laptops">
          </a>
        </div>
        <div class="carousel-slide">
          <a href="shop.php?cat=gaming">
            <img src="images/banner3.jpg" alt="Gaming Accessories">
          </a>
        </div>
      </div>
      <!-- Navigation Arrows -->
      <div class="carousel-nav carousel-prev">&#10094;</div>
      <div class="carousel-nav carousel-next">&#10095;</div>
      <!-- Dots Indicator -->
      <div class="carousel-dots">
        <span class="dot active" data-slide="0"></span>
        <span class="dot" data-slide="1"></span>
        <span class="dot" data-slide="2"></span>
      </div>
      <a href="shop.php" class="view-all-products-btn orange-btn">View All Products</a>
    </div>
  </section>

  <!-- Shop by Categories - Vishal Peripherals Style -->
  <section class="categories-section slide-up">
    <div class="container">
      <h2 class="section-title">Shop by Categories</h2>
      <div class="category-slider-container">
<div class="category-slider" id="categoriesSlider" data-items="5">
        <a href="shop.php?cat=harddisk" class="cat-slide-item">
          <div class="cat-thumb"><img src="images/pc.webp" alt="Hard Disks"></div>
          <div class="category-details"><h3>Antivirus</h3><span class="product-count">167 Products</span></div>
        </a>
        <a href="shop.php?cat=cabinet" class="cat-slide-item">
          <div class="cat-thumb"><img src="admin_area/product_images/gaming-pc.jpg" alt="Cabinets"></div>
          <div class="category-details"><h3>Cabinets</h3><span class="product-count">574 Products</span></div>
        </a>
        <a href="shop.php?cat=laptop" class="cat-slide-item">
          <div class="cat-thumb"><img src="images/laptop.webp" alt="Laptops"></div>
          <div class="category-details"><h3>Laptops</h3><span class="product-count">311 Products</span></div>
        </a>
        <a href="shop.php?cat=motherboard" class="cat-slide-item">
          <div class="cat-thumb"><img src="admin_area/product_images/product-1.jpg" alt="Motherboards"></div>
          <div class="category-details"><h3>Motherboards</h3><span class="product-count">367 Products</span></div>
        </a>
        <a href="shop.php?cat=processor" class="cat-slide-item">
          <div class="cat-thumb"><img src="admin_area/product_images/product-2.jpg" alt="Processors"></div>
          <div class="category-details"><h3>Processors</h3><span class="product-count">96 Products</span></div>
        </a>
        <a href="shop.php?cat=monitor" class="cat-slide-item">
          <div class="cat-thumb"><img src="admin_area/product_images/product-3.jpg" alt="Monitors"></div>
          <div class="category-details"><h3>Monitors</h3><span class="product-count">567 Products</span></div>
        </a>
        <a href="shop.php?cat=graphics" class="cat-slide-item">
          <div class="cat-thumb"><img src="images/gaming.jpg" alt="Graphic Cards"></div>
          <div class="category-details"><h3>Graphic Cards</h3><span class="product-count">313 Products</span></div>
        </a>
        <a href="shop.php?cat=powersupply" class="cat-slide-item">
          <div class="cat-thumb"><img src="admin_area/product_images/mouse.jpg" alt="Power Supply"></div>
          <div class="category-details"><h3>Power Supply</h3><span class="product-count">232 Products</span></div>
        </a>
        </div>
        <div class="slider-nav-btn prev-btn" data-slider="categoriesSlider">&#10094;</div>
        <div class="slider-nav-btn next-btn" data-slider="categoriesSlider">&#10095;</div>
      </div>
    </div>
  </section>

  <!-- Featured Collection - 5 Products Per Row with Slider -->
  <section class="featured-section slide-up">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Featured Products</h2>
        <a href="shop.php" class="view-all-link">View All <i class="fas fa-arrow-right"></i></a>
      </div>
      <div class="product-slider-container">
<div class="product-slider" id="featuredSlider" data-items="4">
          <?php 
          $get_featured = "SELECT * FROM products 
                 WHERE cat_id = 2 
                 AND (product_label='featured' OR product_label='new') 
                 LIMIT 15";

          $run_featured = mysqli_query($con, $get_featured);
          
          if(mysqli_num_rows($run_featured) == 0) {
            // Fallback to any products if no featured found
            $get_featured = "SELECT * FROM products LIMIT 15";
            $run_featured = mysqli_query($con, $get_featured);
          }
          
          while($row = mysqli_fetch_array($run_featured)){
            $pro_id = $row['product_id'];
            $pro_title = $row['product_title'];
            $pro_img1 = $row['product_img1'];
            $pro_price = $row['product_price'];
            $pro_psp_price = isset($row['product_psp_price']) ? $row['product_psp_price'] : 0;
            
            $discount = 0;
            if($pro_psp_price > 0){
              $discount = round((($pro_price - $pro_psp_price) / $pro_price) * 100);
            }
            
            echo "
            <div class='product-slide-item'>
              ".($discount > 0 ? "<div class='discount-tag'>-$discount%</div>" : "")."
<div class='product-image'>
                <a href='details.php?pro_id=$pro_id'>
                  <img src='admin_area/product_images/$pro_img1' alt='$pro_title'>
                </a>
                <button class='wishlist-btn' data-product-id='$pro_id' title='Add to Wishlist'>
                  <i class='far fa-heart'></i>
                </button>
              </div>
              <div class='product-details'>
                <h3><a href='details.php?pro_id=$pro_id'>$pro_title</a></h3>
                <div class='product-price'>
                  ".($pro_psp_price > 0 ? "<span class='old-price'>₹$pro_price</span><span class='current-price'>₹$pro_psp_price</span>" : "<span class='current-price'>₹$pro_price</span>")."
                </div>
<div class='product-actions'>
                  <a href='index.php?add_cart=$pro_id' class='add-cart-btn orange-btn'>Add to Cart</a>
                  <a href='index.php?add_cart=$pro_id&buy_now=1' class='buy-now-btn'>Buy Now</a>
                </div>
              </div>
            </div>
            ";
          }
          ?>
        </div>
        <div class="slider-nav-btn prev-btn" data-slider="featuredSlider">&#10094;</div>
        <div class="slider-nav-btn next-btn" data-slider="featuredSlider">&#10095;</div>
      </div>
    </div>
  </section>

  <!-- Best Sellers Section - 5 Products Per Row with Slider -->
  <section class="bestsellers-section slide-up">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Best Sellers</h2>
        <a href="shop.php?filter=bestseller" class="view-all-link">View All <i class="fas fa-arrow-right"></i></a>
      </div>
      <div class="product-slider-container">
<div class="product-slider" id="bestsellersSlider" data-items="4">
          <?php
          $get_best_sellers = "SELECT * FROM products 
                 WHERE cat_id = 2 
                 AND (product_label='bestsellers') 
                 LIMIT 15";

          $run_best_sellers = mysqli_query($con, $get_best_sellers);
          
          if(mysqli_num_rows($run_best_sellers) == 0) {
            // Fallback to latest products if no bestsellers found
            $get_best_sellers = "SELECT * FROM products ORDER BY product_id DESC LIMIT 15";
            $run_best_sellers = mysqli_query($con, $get_best_sellers);
          }

          while($row = mysqli_fetch_array($run_best_sellers)){
              $pro_id = $row['product_id'];
              $pro_title = $row['product_title'];
              $pro_img1 = $row['product_img1'];
              $pro_price = $row['product_price'];
              $pro_psp_price = isset($row['product_psp_price']) ? $row['product_psp_price'] : 0;
              
              $discount = 0;
              if($pro_psp_price > 0){
                $discount = round((($pro_price - $pro_psp_price) / $pro_price) * 100);
              }

              echo "
              <div class='product-slide-item bestseller'>
                ".($discount > 0 ? "<div class='discount-tag'>-$discount%</div>" : "")."
                <div class='bestseller-badge'>Best Seller</div>
<div class='product-image'>
                  <a href='details.php?pro_id=$pro_id'>
                    <img src='admin_area/product_images/$pro_img1' alt='$pro_title'>
                  </a>
                  <button class='wishlist-btn' data-product-id='$pro_id' title='Add to Wishlist'>
                    <i class='far fa-heart'></i>
                  </button>
                </div>
                <div class='product-details'>
                  <h3><a href='details.php?pro_id=$pro_id'>$pro_title</a></h3>
                  <div class='product-price'>
                    ".($pro_psp_price > 0 ? "<span class='old-price'>₹$pro_price</span><span class='current-price'>$$pro_psp_price</span>" : "<span class='current-price'>$$pro_price</span>")."
                  </div>
<div class='product-actions'>
                    <a href='index.php?add_cart=$pro_id' class='add-cart-btn orange-btn'>Add to Cart</a>
                    <a href='index.php?add_cart=$pro_id&buy_now=1' class='buy-now-btn'>Buy Now</a>
                  </div>
                </div>
              </div>
              ";
          }
          ?>
        </div>
        <div class="slider-nav-btn prev-btn" data-slider="bestsellersSlider">&#10094;</div>
        <div class="slider-nav-btn next-btn" data-slider="bestsellersSlider">&#10095;</div>
      </div>
    </div>
  </section>

  <!-- Hot Deals Section -->
  <section class="hot-deals-section slide-up">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Hot Deals</h2>
        <a href="shop.php?filter=deals" class="view-all-link">View All <i class="fas fa-arrow-right"></i></a>
      </div>
      <div class="product-slider-container">
<div class="product-slider" id="hotDealsSlider" data-items="4">
          <?php
          $get_hot_deals = "SELECT * FROM products 
                 WHERE cat_id = 2 
                 AND (product_price > product_psp_price AND product_psp_price > 0) 
                 LIMIT 15";
          $run_hot_deals = mysqli_query($con, $get_hot_deals);
          
          if(mysqli_num_rows($run_hot_deals) == 0) {
            // Fallback to random products if no deals found
            $get_hot_deals = "SELECT * FROM products ORDER BY RAND() LIMIT 15";
            $run_hot_deals = mysqli_query($con, $get_hot_deals);
          }

          while($row = mysqli_fetch_array($run_hot_deals)){
              $pro_id = $row['product_id'];
              $pro_title = $row['product_title'];
              $pro_img1 = $row['product_img1'];
              $pro_price = $row['product_price'];
              $pro_psp_price = isset($row['product_psp_price']) ? $row['product_psp_price'] : 0;
              
              $discount = 0;
              if($pro_psp_price > 0){
                $discount = round((($pro_price - $pro_psp_price) / $pro_price) * 100);
              }

              echo "
              <div class='product-slide-item'>
                <div class='hot-deal-badge'>HOT DEAL</div>
                ".($discount > 0 ? "<div class='discount-tag'>-$discount%</div>" : "")."
<div class='product-image'>
                  <a href='details.php?pro_id=$pro_id'>
                    <img src='admin_area/product_images/$pro_img1' alt='$pro_title'>
                  </a>
                  <button class='wishlist-btn' data-product-id='$pro_id' title='Add to Wishlist'>
                    <i class='far fa-heart'></i>
                  </button>
                </div>
                <div class='product-details'>
                  <h3><a href='details.php?pro_id=$pro_id'>$pro_title</a></h3>
                  <div class='product-price'>
                    ".($pro_psp_price > 0 ? "<span class='old-price'>₹$pro_price</span><span class='current-price'>₹$pro_psp_price</span>" : "<span class='current-price'>₹$pro_price</span>")."
                  </div>
<div class='product-actions'>
                    <a href='index.php?add_cart=$pro_id' class='add-cart-btn orange-btn'>Add to Cart</a>
                    <a href='index.php?add_cart=$pro_id&buy_now=1' class='buy-now-btn'>Buy Now</a>
                  </div>
                </div>
              </div>
              ";
          }
          ?>
        </div>
        <div class="slider-nav-btn prev-btn" data-slider="hotDealsSlider">&#10094;</div>
        <div class="slider-nav-btn next-btn" data-slider="hotDealsSlider">&#10095;</div>
      </div>
    </div>
  </section>

  <!-- Best Picks Section -->
  <section class="best-picks-section slide-up">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Best Picks</h2>
        <a href="shop.php?filter=picks" class="view-all-link">View All <i class="fas fa-arrow-right"></i></a>
      </div>
      <div class="product-slider-container">
<div class="product-slider" id="bestPicksSlider" data-items="4">
          <?php
          $get_best_picks = "SELECT * FROM products 
                 WHERE cat_id = 2 
                 AND (product_label='featured' or product_label='new') 
                 LIMIT 15";
          $run_best_picks = mysqli_query($con, $get_best_picks);
          
          if(mysqli_num_rows($run_best_picks) == 0) {
            // Fallback to highest rated or most recent products
            $get_best_picks = "SELECT * FROM products ORDER BY product_id DESC LIMIT 15";
            $run_best_picks = mysqli_query($con, $get_best_picks);
          }

          while($row = mysqli_fetch_array($run_best_picks)){
              $pro_id = $row['product_id'];
              $pro_title = $row['product_title'];
              $pro_img1 = $row['product_img1'];
              $pro_price = $row['product_price'];
              $pro_psp_price = isset($row['product_psp_price']) ? $row['product_psp_price'] : 0;
              
              $discount = 0;
              if($pro_psp_price > 0){
                $discount = round((($pro_price - $pro_psp_price) / $pro_price) * 100);
              }

              echo "
              <div class='product-slide-item'>
                <div class='best-pick-badge'>EDITOR'S CHOICE</div>
                ".($discount > 0 ? "<div class='discount-tag'>-$discount%</div>" : "")."
<div class='product-image'>
                    <a href='details.php?pro_id=$pro_id'>
                      <img src='admin_area/product_images/$pro_img1' alt='$pro_title'>
                    </a>
                    <button class='wishlist-btn' data-product-id='$pro_id' title='Add to Wishlist'>
                      <i class='far fa-heart'></i>
                    </button>
                  </div>
                <div class='product-details'>
                  <h3><a href='details.php?pro_id=$pro_id'>$pro_title</a></h3>
                  <div class='product-price'>
                    ".($pro_psp_price > 0 ? "<span class='old-price'>₹$pro_price</span><span class='current-price'>₹$pro_psp_price</span>" : "<span class='current-price'>₹$pro_price</span>")."
                  </div>
<div class='product-actions'>
                    <a href='index.php?add_cart=$pro_id' class='add-cart-btn orange-btn'>Add to Cart</a>
                    <a href='index.php?add_cart=$pro_id&buy_now=1' class='buy-now-btn'>Buy Now</a>
                  </div>
                </div>
              </div>
              ";
          }
          ?>
        </div>
        <div class="slider-nav-btn prev-btn" data-slider="bestPicksSlider">&#10094;</div>
        <div class="slider-nav-btn next-btn" data-slider="bestPicksSlider">&#10095;</div>
      </div>
    </div>
  </section>

  <!-- Why Buy / Customer Reviews styled like reference -->
  <section class="why-buy slide-up">
    <div class="container">
      <h2 class="why-title">Why Buy From Us?</h2>
      <div class="why-grid">
        <!-- Left: What people say -->
        <div class="review-panel">
          <h4 class="review-heading">WHAT PEOPLE SAY:</h4>
          <div class="review-quote">
            <i class="fas fa-quote-left"></i>
          </div>
          <div class="review-slider2">
            <div class="review-item2 active">
              <div class="review-stars">
                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star-half-alt"></i>
              </div>
              <p class="review-text">Well response and fast delivery</p>
              <p class="review-author">Mohamed Ismail, Thanjavur</p>
            </div>
            <div class="review-item2">
              <div class="review-stars">
                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
              </div>
              <p class="review-text">Amazing products and super fast delivery. My new PC setup is perfect!</p>
              <p class="review-author">Rahul Sharma, Mumbai</p>
            </div>
            <div class="review-item2">
              <div class="review-stars">
                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="far fa-star"></i>
              </div>
              <p class="review-text">Best customer service I've experienced. Highly recommended!</p>
              <p class="review-author">Priya Kapoor, Delhi</p>
            </div>
            <div class="review-item2">
              <div class="review-stars">
                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star-half-alt"></i><i class="far fa-star"></i>
              </div>
              <p class="review-text">Great pricing and authentic products. Very satisfied with the purchase.</p>
              <p class="review-author">Ankit Verma, Jaipur</p>
            </div>
            <div class="review-item2">
              <div class="review-stars">
                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="far fa-star"></i>
              </div>
              <p class="review-text">Quick issue resolution and friendly support team. Five stars!</p>
              <p class="review-author">Sana Sheikh, Hyderabad</p>
            </div>
            <div class="review-item2">
              <div class="review-stars">
                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star-half-alt"></i><i class="far fa-star"></i>
              </div>
              <p class="review-text">Product packaging was excellent and delivery was on time.</p>
              <p class="review-author">Rohit Kulkarni, Pune</p>
            </div>
            <div class="review-nav-btn prev" id="review2Prev">&#10094;</div>
            <div class="review-nav-btn next" id="review2Next">&#10095;</div>
          </div>
          <div class="review-dots"></div>
        </div>

        <!-- Right: Feature cards -->
        <div class="features-panel">
          <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-truck"></i></div>
            <div class="feature-body">
              <div class="feature-title">SINCE 2001</div>
              <div class="feature-sub">Since 2001</div>
            </div>
          </div>
          <div class="feature-card">
            <div class="feature-icon"><i class="fas fa-file-invoice"></i></div>
            <div class="feature-body">
              <div class="feature-title">GST INVOICE</div>
              <div class="feature-sub">GST Invoice</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Footer -->
<?php
include("includes/footer.php");
?>

</main>

<script>
// Banner Carousel Functionality
let currentSlide = 0;
const slides = document.querySelectorAll('.carousel-slide');
const dots = document.querySelectorAll('.dot');
const totalSlides = slides.length;

function showSlide(n) {
  slides[currentSlide].classList.remove('active');
  dots[currentSlide].classList.remove('active');
  
  currentSlide = (n + totalSlides) % totalSlides;
  
  slides[currentSlide].classList.add('active');
  dots[currentSlide].classList.add('active');
}

function nextSlide() {
  showSlide(currentSlide + 1);
}

function prevSlide() {
  showSlide(currentSlide - 1);
}

// Event listeners for carousel
document.querySelector('.carousel-next').addEventListener('click', nextSlide);
document.querySelector('.carousel-prev').addEventListener('click', prevSlide);

// Dot navigation
dots.forEach((dot, index) => {
  dot.addEventListener('click', () => showSlide(index));
});

// Auto-slide every 5 seconds
setInterval(nextSlide, 5000);


// Sidebar animations on scroll
function animateOnScroll() {
  const widgets = document.querySelectorAll('.sidebar-widget');
  
  widgets.forEach(widget => {
    const rect = widget.getBoundingClientRect();
    const isVisible = rect.top < window.innerHeight && rect.bottom > 0;
    
    if (isVisible) {
      widget.style.animationDelay = '0.2s';
      widget.classList.add('fade-in-up');
    }
  });
}

window.addEventListener('scroll', animateOnScroll);
window.addEventListener('load', animateOnScroll);

// Product Slider Functionality (6 per row)
const productSliders = {};

function initProductSlider(sliderId) {
  const slider = document.getElementById(sliderId);
  if (!slider) return;
  
  const items = slider.querySelectorAll('.product-slide-item, .cat-slide-item');
  const totalItems = items.length;
  const itemsPerView = parseInt(slider.getAttribute('data-items') || '5', 10);
  const maxIndex = Math.max(0, totalItems - itemsPerView);
  
  productSliders[sliderId] = {
    currentIndex: 0,
    maxIndex: maxIndex,
    itemWidth: 100 / itemsPerView // 20% for 5 items
  };
}

function slideProducts(sliderId, direction) {
  const slider = document.getElementById(sliderId);
  if (!slider || !productSliders[sliderId]) return;
  
  const sliderData = productSliders[sliderId];
  
  if (direction === 'next' && sliderData.currentIndex < sliderData.maxIndex) {
    sliderData.currentIndex++;
  } else if (direction === 'prev' && sliderData.currentIndex > 0) {
    sliderData.currentIndex--;
  }
  
  const translateX = -(sliderData.currentIndex * sliderData.itemWidth);
  slider.style.transform = `translateX(${translateX}%)`;
}

// Wishlist toggle with localStorage persistence
function loadWishlist() {
  try {
    return JSON.parse(localStorage.getItem('wishlist') || '[]');
  } catch (e) { return []; }
}

function saveWishlist(list) {
  localStorage.setItem('wishlist', JSON.stringify(list));
}

function setWishlistUI() {
  const wishlist = loadWishlist();
  document.querySelectorAll('.wishlist-btn').forEach(btn => {
    const id = btn.getAttribute('data-product-id');
    if (wishlist.includes(id)) {
      btn.classList.add('active');
      const icon = btn.querySelector('i');
      if (icon) { icon.classList.remove('far'); icon.classList.add('fas'); }
    }
  });
}

function toggleWishlist(id, btn) {
  let wishlist = loadWishlist();
  const exists = wishlist.includes(id);
  if (exists) {
    wishlist = wishlist.filter(x => x !== id);
    btn.classList.remove('active');
    const icon = btn.querySelector('i');
    if (icon) { icon.classList.remove('fas'); icon.classList.add('far'); }
  } else {
    wishlist.push(id);
    btn.classList.add('active');
    const icon = btn.querySelector('i');
    if (icon) { icon.classList.remove('far'); icon.classList.add('fas'); }
  }
  saveWishlist(wishlist);
}

// Initialize all product sliders and wishlist
document.addEventListener('DOMContentLoaded', function() {
  initProductSlider('featuredSlider');
  initProductSlider('bestsellersSlider');
  initProductSlider('hotDealsSlider');
  initProductSlider('bestPicksSlider');
  initProductSlider('categoriesSlider');
  
  // Add click events to navigation buttons
  document.querySelectorAll('.slider-nav-btn').forEach(btn => {
    btn.addEventListener('click', function() {
      const sliderId = this.getAttribute('data-slider');
      const direction = this.classList.contains('next-btn') ? 'next' : 'prev';
      slideProducts(sliderId, direction);
    });
  });

  // Wishlist toggle events
  document.body.addEventListener('click', function(e) {
    const btn = e.target.closest('.wishlist-btn');
    if (!btn) return;
    const id = btn.getAttribute('data-product-id');
    if (!id) return;
    toggleWishlist(id, btn);
  });

  // Set initial UI state for wishlist
  setWishlistUI();
});
// Reviews 2 slider with dots and arrows (auto 4s)
(function(){
  const items = document.querySelectorAll('.review-slider2 .review-item2');
  if (!items.length) return;
  const dotsBox = document.querySelector('.review-dots');
  items.forEach((_,i)=>{ const s=document.createElement('span'); s.addEventListener('click', ()=>{ show(i); restart(); }); dotsBox.appendChild(s); });
  let dots = dotsBox.querySelectorAll('span');
  let idx = 0;
  let timer = null;
  function show(i){
    items[idx].classList.remove('active');
    dots[idx].classList.remove('active');
    idx = (i + items.length) % items.length;
    items[idx].classList.add('active');
    dots[idx].classList.add('active');
  }
function start(){ timer = setInterval(()=>show(idx+1), 4000); }
  function stop(){ if (timer) { clearInterval(timer); timer = null; } }
  function restart(){ stop(); start(); }
  show(0);
  start();
  // arrow events
  const prev = document.getElementById('review2Prev');
  const next = document.getElementById('review2Next');
  if (prev) prev.addEventListener('click', ()=>{ show(idx-1); restart(); });
  if (next) next.addEventListener('click', ()=>{ show(idx+1); restart(); });
})();
</script>

</body>

<!-- CSS -->
<style>
  /* Featured Collection Slider */
.featured-slider {
  position: relative;
  overflow: hidden;
  width: 100%;
  margin: 30px auto;
}

.featured-container {
  display: flex;
  transition: transform 0.5s ease-in-out;
}

.featured-container .product-card {
  flex: 0 0 25%; /* Default: 4 per slide (desktop) */
  max-width: 25%;
  padding: 10px;
  box-sizing: border-box;
}

.product-card {
  background: #fff;
  border-radius: 10px;
  padding: 15px;
  text-align: center;
  height: 300px; /* square-ish */
  display: flex;
  flex-direction: column;
  justify-content: space-between;
  box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}

.product-card img {
  max-height: 150px;
  object-fit: contain;
}

/* Navigation */
.featured-nav {
  position: absolute;
  top: 40%;
  font-size: 2rem;
  color: #333;
  cursor: pointer;
  user-select: none;
  padding: 10px;
  z-index: 10;
}
.featured-nav.prev { left: 5px; }
.featured-nav.next { right: 5px; }

/* Dots */
.featured-dots {
  text-align: center;
  margin-top: 10px;
}
.featured-dots span {
  height: 12px;
  width: 12px;
  margin: 0 4px;
  display: inline-block;
  border-radius: 50%;
  background: #bbb;
  cursor: pointer;
}
.featured-dots .active {
  background: #333;
}

/* ✅ Responsive */
@media (max-width: 1024px) {
  .featured-container .product-card {
    flex: 0 0 33.33%; /* 3 per slide on tablets */
    max-width: 33.33%;
  }
}
@media (max-width: 768px) {
  .featured-container .product-card {
    flex: 0 0 50%; /* 2 per slide on mobile */
    max-width: 50%;
  }
}
@media (max-width: 480px) {
  .featured-container .product-card {
    flex: 0 0 100%; /* 1 per slide on very small screens */
    max-width: 100%;
  }
}


</style>
<script>
  let slider = document.querySelector('.slider-container');
let slides = document.querySelectorAll('.slide');
let dotsContainer = document.querySelector('.slider-dots');
let index = 0;

// Create dots
slides.forEach((s,i) => {
  let dot = document.createElement('span');
  dot.addEventListener('click', () => showSlide(i));
  dotsContainer.appendChild(dot);
});
let dots = dotsContainer.querySelectorAll('span');

function showSlide(i){
  index = i;
  slider.style.transform = `translateX(${-index * 100}%)`;
  dots.forEach(d => d.classList.remove('active'));
  dots[index].classList.add('active');
}
function nextSlide(){ showSlide((index + 1) % slides.length); }
function prevSlide(){ showSlide((index - 1 + slides.length) % slides.length); }

document.querySelector('.next').addEventListener('click', nextSlide);
document.querySelector('.prev').addEventListener('click', prevSlide);

showSlide(0);
setInterval(nextSlide, 5000);
let fSlider = document.querySelector('.featured-container');
let fSlides = document.querySelectorAll('.featured-container .product-card');
let fDotsContainer = document.querySelector('.featured-dots');
let fIndex = 0;
let fPerSlide = getPerSlide();
let fTotal = Math.ceil(fSlides.length / fPerSlide);

// Function to detect items per slide based on screen size
function getPerSlide() {
  if (window.innerWidth <= 480) return 1;
  if (window.innerWidth <= 768) return 2;
  if (window.innerWidth <= 1024) return 3;
  return 4;
}

// Create dots dynamically
function createFDots(){
  fDotsContainer.innerHTML = "";
  fPerSlide = getPerSlide();
  fTotal = Math.ceil(fSlides.length / fPerSlide);
  for(let i=0; i<fTotal; i++){
    let dot = document.createElement('span');
    dot.addEventListener('click', () => showFSlide(i));
    fDotsContainer.appendChild(dot);
  }
  fDots = fDotsContainer.querySelectorAll('span');
  showFSlide(0);
}
function showFSlide(i){
  fIndex = i;
  fSlider.style.transform = `translateX(${-i * 100}%)`;
  fDots.forEach(d => d.classList.remove('active'));
  if(fDots[fIndex]) fDots[fIndex].classList.add('active');
}

function nextFSlide(){ showFSlide((fIndex + 1) % fTotal); }
function prevFSlide(){ showFSlide((fIndex - 1 + fTotal) % fTotal); }

document.querySelector('.featured-nav.next').addEventListener('click', nextFSlide);
document.querySelector('.featured-nav.prev').addEventListener('click', prevFSlide);

createFDots();
setInterval(nextFSlide, 7000);

// Recalculate on window resize
window.addEventListener('resize', createFDots);
</script>

</html>