<!-- FontAwesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
  body { margin:0; font-family: 'Segoe UI', Arial, sans-serif; background:#fff; }

  /* Top strip */
  .top-strip {
    background: #1e40af;
    color: #fff;
    font-size: 14px;
    width: 100%;
    padding: 0;
  }
  .top-bar-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
    height: 44px;
  }
  .top-left, .top-right { display: flex; align-items: center; gap: 26px; }
  .top-left span, .top-right a { color:#fff; text-decoration:none; font-size:15px; display:flex; align-items:center; gap:7px; }

  /* Header main row */
  .header-main {
    display:flex;
    align-items:center;
    padding:14px 20px;
    background:#fff;
    border-bottom:1px solid #eee;
  }
  .header-main .logo img { height: 96px; width: 105px; }

  /* Search */
  .header-search {
    flex:1;
    display:flex;
    margin:0 25px;
    max-width: 700px; /* wider search */
  }
  .header-search input {
    flex:1;
    padding:12px 14px;
    border:2px solid #1e40af;
    border-right: none;
    border-radius:8px 0 0 8px;
    font-size:15px;
  }
  .header-search button {
    padding:12px 18px;
    border:none;
    background:linear-gradient(135deg, #1e40af, #2563eb);
    color:#fff;
    font-size:16px;
    border-radius:0 8px 8px 0;
    cursor:pointer;
    transition: all 0.3s ease;
  }
  .header-search button:hover {
    background:linear-gradient(135deg, #2563eb, #1e40af);
    transform: scale(1.05);
  }

  /* Hardware button */
  .hardware-btn {
    margin-left:15px;
    padding:12px 20px;
    background: linear-gradient(135deg, #ea580c, #f97316);
    color:#fff;
    border-radius:8px;
    font-weight:600;
    text-decoration:none;
    transition: all 0.3s ease;
    white-space: nowrap;
  }
  .hardware-btn:hover {
    background: linear-gradient(135deg, #f97316, #ea580c);
    transform: scale(1.05);
  }

  /* Icons */
  .header-icons a {
    margin-left:15px;
    color:#333;
    font-size:20px;
    transition: color .3s;
  }
  .header-icons a:hover { color:#1e40af; }
.top-left, .top-right {
  display: flex;
  align-items: center;
  gap: 26px; /* Space between items */
}

.top-left span, .top-right a {
  display: flex;
  align-items: center;
  color: #fff;
  text-decoration: none;
  font-size: 15px;
  gap: 7px;
}

.top-right a {
  margin-left: 22px;
}

.top-strip i {
  font-size: 17px;
  margin-right: 5px;
}


  /* Header main row */
  .header-main {
    display:flex;
    align-items:center;
    padding:12px 20px;
    background:#fff;
    border-bottom:1px solid #eee;
  }
  .header-main .logo img {
    height: 96px;
    width: 105px;
}

  /* Search */
  .header-search {
    flex:1;
    display:flex;
    margin:0 20px;
  }
  .header-search input {
    flex:1;
    padding:8px 12px;
    border:1px solid #ccc;
    border-radius:4px 0 0 4px;
  }
  .header-search button {
    padding:8px 14px;
    border:none;
    background:#1e40af;
    color:#fff;
    border-radius:0 4px 4px 0;
    cursor:pointer;
    transition: all 0.3s ease;
  }
  .header-search button:hover {
    background: #1d4ed8;
  }

  /* Icons */
  .header-icons a {
    margin-left:15px;
    color:#333;
    font-size:18px;
  }
  .header-icons a:hover { color:#1e40af; }

  /* Navigation bar */
  .nav-bar {
    background:#fff;
    border-top:1px solid #eee;
    border-bottom:1px solid #eee;
    padding:0 20px;
    position: relative;
    z-index: 100;
  }
  .nav-bar.is-sticky {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    z-index: 3000;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    background: #fff;
  }
  .nav-bar ul {
    margin:0;
    padding:0;
    list-style:none;
    display:flex;
    gap:20px;
    align-items:center;
  }
  .nav-bar #nav{
  gap: 10px !important;
 }
  .nav-bar li {
    position:relative;
  }
  .nav-bar a {
    text-decoration:none;
    font-weight:500;
    color:#333;
    display:block;
    padding:14px 0;
    cursor:pointer;
  }
#categories-toggle {
    background: #ea580c; /* All Categories bar in orange */
    border: none;
    border-radius: 6px;
    padding: 8px 16px;
    transition: all 0.3s ease;
    position: relative; /* anchor for absolute submenus */
  }
  #categories-toggle:hover{
    background: #d64e09;
    color:#fff;
  }
  #categories-toggle a {
    color: #fff !important;
    font-weight: 600;
  }
  .nav-bar a:hover { color:#1e40af; }
  /* Reduce padding and margin in main category items */
.categories-menu li {
    padding: 6px 12px; /* Reduced vertical and horizontal padding */
    border-bottom: 1px solid rgba(255,255,255,0.13);
    font-size: 15px;
    gap: 4px; /* smaller gap between icon and text */
}

/* Reduce icon margin */
.categories-menu li i {
    margin-right: 6px;
}

/* Reduce padding in nested subcategory items */
.categories-menu li ul li {
    padding: 6px 14px;
    border-bottom: 1px solid rgba(255,255,255,0.15);
    font-size: 14px;
}

/* Make nested submenu a bit narrower for better fit */
.categories-menu li ul {
    width: 200px;
}

  /* Categories dropdown menu (vertical) */
.categories-menu {
    position: absolute;
    top: 100%;
    left: 0;
    width: 260px;
    background: #e0f2fe; /* sky-blue dropdown */
    display: none;
    flex-direction: column;
    z-index: 3500;
    border-radius: 8px;
    border: none; /* remove border */
    box-shadow: 0 12px 40px rgba(2, 6, 23, 0.12);
    opacity: 0;
    pointer-events: none;
    transition: opacity 0.3s ease;
    padding: 4px 0; /* remove extra outer gaps */
    max-height: calc(100vh - 180px); /* fit viewport under fixed header */
    overflow-y: auto;
    scroll-behavior: smooth;
    direction: rtl; /* move scrollbar left */
}
/* scrollbar styling */
.categories-menu::-webkit-scrollbar { width: 8px; }
.categories-menu::-webkit-scrollbar-thumb { background:#93c5fd; border-radius: 6px; }
.categories-menu::-webkit-scrollbar-track { background:#e0f2fe; }
/* flip contents back to LTR so text stays aligned left */
.categories-menu > * { direction: ltr; }
  

.categories-menu.active {
    display: flex;
    opacity: 1;
    pointer-events: auto;
}

.categories-menu li {
    padding: 6px 10px; /* reduced top/bottom padding, less left gap */
    gap: 6px;
    border-bottom: 1px solid #eef2f7;
    font-size: 14px;
    text-align: left;
    color: #0f172a; /* black text */
    line-height: 1.2;
  }
  .categories-menu li a {
    color:#0f172a !important;
    text-decoration:none;
    display:block;
    text-align:left;
    padding: 0; /* remove inner link padding */
    margin: 0;
  }
  .categories-menu li i { margin-right:8px; color:#0f172a; }
/* Hover effect - sky blue tint */
  .categories-menu li:hover {
    background: #dbeafe;   /* lighter sky */
    color: #0f172a;        /* keep text black */
  }
  .categories-menu li:hover i {
    color: #0f172a;        /* keep icon black */
  }
  /* nested submenu spacing */
  .categories-menu li ul { padding: 0; }
  .categories-menu li ul li { padding: 6px 12px; }

  /* Submenu (nested categories) */
.categories-menu li ul { display:none !important; } /* keep internal submenus hidden */

/* External submenu panel */
.categories-submenu {
  position: absolute;
  top: 0;   /* will be positioned dynamically beside hovered item */
  left: 0;  /* will be positioned dynamically beside hovered item */
  width: 260px;
  background: #ffffff;
  border: none; /* remove border */
  border-radius: 8px;
  box-shadow: 0 12px 40px rgba(2,6,23,.12);
  display: none;
  flex-direction: column;
  max-height: calc(100vh - 180px); /* match viewport */
  overflow-y: auto;
  padding: 4px 0;
  z-index: 3600;
  direction: rtl; /* scrollbar left */
}
.categories-submenu > * { direction: ltr; }
.categories-submenu.active { display:flex; }
/* Ensure submenu hides when main dropdown closed */
#categories-menu:not(.active) + #categories-submenu { display: none !important; }
.categories-submenu li { list-style:none; padding:6px 12px; color:#0f172a; font-size:14px; text-align:left; }
.categories-submenu li:hover { background:#f3f4f6; }

  /* Active state */
  .categories-menu.active {
    display:flex;
  }

  /* Responsive adjustments */
  @media (max-width: 768px) {
    .top-bar-content {
      flex-direction: column;
      justify-content: center;
      align-items: flex-start;
      height: auto;
      padding: 6px 10px;
      gap: 6px;
    }
    .top-left, .top-right { gap: 10px; }
    .top-left span, .top-right a { font-size: 14px; }

    .header-main {
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 12px;
    }
    .header-main .logo img { height: 44px; width: auto; }

    .header-search {
      order: 3;
      width: 100%;
      margin: 8px 0 0;
    }
    .header-search input { font-size: 14px; }
    .header-search button { padding: 8px 12px; }

    .header-icons { order: 2; margin-left: auto; }
    .header-icons a { font-size: 16px; margin-left: 12px; }

    .nav-bar { padding: 0 12px; }
    .nav-bar ul {
      gap: 12px;
      overflow-x: auto;
      white-space: nowrap;
      scrollbar-width: thin;
    }
    .nav-bar a { padding: 10px 0; font-size: 14px; }
    #categories-toggle { padding: 6px 10px; }
    #categories-toggle a { font-size: 14px; }

    .categories-menu, .categories-submenu {
      max-height: calc(100vh - 120px);
    }
  }

  @media (max-width: 480px) {
    .top-left span:nth-child(n+2) { display: none; }
    .top-right a { display: none; }

    .header-main { padding: 8px 10px; }
    .header-main .logo img { height: 38px; }

    .header-icons a { margin-left: 10px; font-size: 16px; }

    .nav-bar ul { gap: 8px; }
    .nav-bar a { font-size: 13px; }
    #categories-toggle a { font-size: 13px; }
  }

</style>

<header>
  <!-- Top strip -->
  <div class="top-strip">
    <div class="wrap top-bar-content">
      <div class="top-left">
        <span><i class="fas fa-download"></i> Instant download for software licenses</span>
        <span><i class="fas fa-shipping-fast"></i> Free shipping on orders over ₹25,000</span>
        <span><i class="fas fa-shield-check"></i> Genuine products with warranty</span>
      </div>
      <div class="top-right">
        <a href="tel:+919999888777"><i class="fas fa-phone"></i> +91-9999-888-777</a>
        <a href="mailto:support@vertextech.com"><i class="fas fa-envelope"></i> support@vertextech.com</a>
      </div>
    </div>
  </div>

  <!-- Header main -->
  <div class="header-main">
    <!-- Logo -->
    <div class="logo">
      <a href="index.php"><img src="images/logo.jpg" alt="Logo"></a>
    </div>

    <!-- Search with Hardware button -->
    <div class="header-search">
      <input type="text" placeholder="Search for products...">
      <button><i class="fas fa-search"></i></button>
      <a href="hardware.php" class="hardware-btn"><i class="fas fa-microchip"></i> Hardware</a>
    </div>

    <!-- Icons -->
    <div class="header-icons">
      <a href="checkout.php"><i class="fas fa-user"></i></a>
      <a href="my_wishlist.php"><i class="fas fa-heart"></i></a>
      <a href="cart.php"><i class="fas fa-shopping-cart"></i></a>
    </div>
  </div>
  <!-- Navigation -->
  <div class="nav-bar" >
    <ul>
      <li id="categories-toggle">
        <a><i class="fas fa-bars"></i> All Categories</a>
        <ul class="categories-menu" id="categories-menu" >
          <li>
            <i class="fas fa-microchip"></i> Processor
            <ul>
              <li>Intel</li>
              <li>AMD</li>
            </ul>
          </li>
          <li>
            <i class="fas fa-network-wired"></i> Motherboard
            <ul>
              <li>Intel Socket</li>
              <li>AMD Socket</li>
            </ul>
          </li>
          <li>
            <i class="fas fa-video"></i> Graphics Card
            <ul>
              <li>NVIDIA</li>
              <li>AMD Radeon</li>
            </ul>
          </li>
          <li><i class="fas fa-memory"></i> Memory (RAM)</li>
          <li><i class="fas fa-hdd"></i> Storage</li>
          <li><i class="fas fa-desktop"></i> Monitors</li>
          <li><i class="fas fa-fan"></i> Cooling</li>
          <li><i class="fas fa-gamepad"></i> Gaming Peripherals</li>
          <li><i class="fas fa-box"></i> Cabinets</li>
          <li><i class="fas fa-plug"></i> Power Supply</li>
        </ul>
        <ul class="categories-submenu" id="categories-submenu"></ul>
      </li>
      <li><a href="#">Home</a></li>
      <li><a href="shop.php">Shop</a></li>
      <li><a href="#">Playstation</a></li>
      <li><a href="#">NVIDIA 50 Series PC</a></li>
      <li><a href="#">About Us</a></li>
      <li><a href="#">Contact Us</a></li>
    </ul>
  </div>
</header>

<script>
  document.addEventListener("DOMContentLoaded", function() {
  const toggleBtn = document.querySelector("#categories-toggle > a");
  const catLi = document.getElementById("categories-toggle");
  const menu = document.getElementById("categories-menu");
  const subPanel = document.getElementById("categories-submenu");

  // Click toggles (kept), but we also handle hover below
  toggleBtn.addEventListener("click", function(e) {
    e.preventDefault();
    menu.classList.toggle("active");
    if(!menu.classList.contains('active')) subPanel?.classList.remove('active');
  });

  // Hover open/close (compact & professional)
  const closeAll = ()=>{ menu.classList.remove('active'); subPanel?.classList.remove('active'); };
  catLi.addEventListener('mouseenter', ()=> menu.classList.add('active'));
  catLi.addEventListener('mouseleave', ()=> { if(!(subPanel && subPanel.matches(':hover'))) closeAll(); });
  if(subPanel){
    subPanel.addEventListener('mouseleave', ()=>{
      subPanel.classList.remove('active');
      if(!catLi.matches(':hover') && !menu.matches(':hover')) menu.classList.remove('active');
    });
  }

  // Close dropdown on ESC or outside click
  document.addEventListener("click", function(e) {
    if (!catLi.contains(e.target)) {
      menu.classList.remove("active");
      subPanel?.classList.remove('active');
    }
  });

  document.addEventListener("keydown", function(e) {
    if(e.key === "Escape"){ menu.classList.remove("active"); subPanel?.classList.remove('active'); }
  });
});


// Submenu rendering in a separate dropdown
(function(){
  const main = document.getElementById('categories-menu');
  const panel = document.getElementById('categories-submenu');
  if(!main || !panel) return;

  function showSubmenu(li){
    const sub = li.querySelector(':scope > ul');
    if(!sub){
      panel.classList.remove('active');
      panel.innerHTML='';
      panel.style.top='0px';
      panel.style.left='0px';
      return;
    }
    const items = Array.from(sub.children).map(li2=> `<li>${li2.textContent.trim()}</li>`).join('');
    panel.innerHTML = items;
    // position panel beside hovered li
    const liRect = li.getBoundingClientRect();
    const menuRect = main.getBoundingClientRect();
    // compute offsets relative to positioned ancestor (#categories-toggle li)
    const hostRect = main.parentElement.getBoundingClientRect();
    const top = (menuRect.top - hostRect.top) + (liRect.top - menuRect.top);
    const left = (menuRect.left - hostRect.left) + main.offsetWidth + 2;
    panel.style.top = `${top}px`;
    panel.style.left = `${left}px`;
    panel.classList.add('active');
  }

  main.addEventListener('mouseenter', e=>{
    const li = e.target.closest('li');
    if(!li || !main.contains(li)) return;
    showSubmenu(li);
  }, true);

  main.addEventListener('mouseleave', ()=>{
    if(!panel.matches(':hover')){ panel.classList.remove('active'); panel.innerHTML=''; }
  });
  // Also hide panel if main menu is not active anymore
  const hideIfMainClosed = () => { if(!main.classList.contains('active')) { panel.classList.remove('active'); panel.innerHTML=''; } };
  document.addEventListener('mousemove', hideIfMainClosed, { passive: true });
})();
</script>

<script>
// Make nav bar stick to top on scroll and return to original at top
(function(){
  const nav = document.querySelector('.nav-bar');
  const topStrip = document.querySelector('.top-strip');
  const headerMain = document.querySelector('.header-main');
  if (!nav) return;
  // spacer to prevent layout jump
  let spacer = document.getElementById('nav-spacer');
  if (!spacer) {
    spacer = document.createElement('div');
    spacer.id = 'nav-spacer';
    spacer.style.height = '0px';
    nav.parentNode.insertBefore(spacer, nav.nextSibling);
  }
  const triggerPoint = (topStrip?.offsetHeight || 0) + (headerMain?.offsetHeight || 0);
  function onScroll(){
    if (window.scrollY > triggerPoint) {
      if (!nav.classList.contains('is-sticky')) {
        nav.classList.add('is-sticky');
        spacer.style.height = nav.offsetHeight + 'px';
      }
    } else {
      if (nav.classList.contains('is-sticky')) {
        nav.classList.remove('is-sticky');
        spacer.style.height = '0px';
      }
    }
  }
  window.addEventListener('scroll', onScroll, { passive: true });
  window.addEventListener('resize', ()=>{ if (nav.classList.contains('is-sticky')) spacer.style.height = nav.offsetHeight + 'px'; });
  onScroll();
})();
</script>
